<?php

namespace Mtc\Filter\Listeners;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Mtc\Filter\Contracts\FilterInstance;

class RefreshFilterIndexModel
{
    use DispatchesJobs;

    private FilterInstance $filter;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct(FilterInstance $filter)
    {
        $this->filter = $filter;
    }

    /**
     * Handle the event.
     *
     * @param Model $model
     * @return void
     */
    public function handle(Model $model): void
    {
        $this->filter->findIndexTypesForModel($model)
            ->each(function ($type) use ($model) {
                $filter_object = $this->filter->instantiateFilter($type);
                $job_class = config('filter.filter_update_job_class');
                $this->dispatch(new $job_class($model, $filter_object, $type));
            });
    }
}
