<?php

namespace Mtc\Filter\Sorting;

use Illuminate\Database\Eloquent\Builder;
use Mtc\Filter\Contracts\IsSortOption;

class PriceDescending implements IsSortOption
{
    /**
     * Perform sorting query adjustments
     *
     * @param Builder $query
     * @return Builder
     */
    public function handle(Builder $query): Builder
    {
        return $query->orderByDesc('sort_price');
    }
}
