<?php

use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Config;
use Mtc\Filter\Http\Controllers\FilterAdminController;
use Mtc\Filter\Http\Controllers\FilterController;

$entry_url = Config::get('filter.url_entrypoint');

/** @var Router $router */
$router->get("{$entry_url}{any}", [FilterController::class, 'index'])->where('any', '.*')->name('filter_page');
$router->post("{$entry_url}/", [FilterController::class, 'show'])->name('filter.index');


/** @var Router $router */
$router->group([
    'prefix' => '/admin/',
    'middleware' => [
        'auth'
    ]
], function (Router $router) {
    $router->get("filter", [FilterAdminController::class, 'index']);
    $router->put("filter/{index}", [FilterAdminController::class, 'update']);
    $router->post("filter/{type}/reorder", [FilterAdminController::class, 'reorder']);

});