<?php

namespace Mtc\Filter;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Mtc\Filter\Contracts\FilterIndexContract;
use Mtc\Shop\Item\Size;

class FilterIndex extends FilterIndexContract
{
    /**
     * Cheeky relationship with sizes - helps with value allocation in filter
     *
     * @return HasMany
     */
    public function sizes(): HasMany
    {
        return $this->hasMany(Size::class, 'size', 'filter_id')
            ->where('filter_type', 'size');
    }

    /**
     * Cheeky relationship with colours - helps with value allocation in filter
     *
     * @return HasMany
     */
    public function colours(): HasMany
    {
        return $this->hasMany(Size::class, 'colour', 'filter_id')
            ->where('filter_type', 'colour');
    }
}
