<?php

namespace Mtc\Filter\Facades;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Facade;
use Mtc\Filter\Contracts\FilterInstance;
use Mtc\Filter\Contracts\IsFilter;

/**
 * Class Filter
 * Product Filter Facade
 *
 * @method static string urlForSelections(array $selections)
 * @method static array parseRequest()
 * @method static array handle()
 * @method static Collection getFilters()
 * @method static array getSelections()
 * @method static string getPageUrl(bool $absolute = true)
 * @method static int getCurrentPage()
 * @method static IsFilter instantiateFilter(string $type)
 * @method static Collection findIndexTypesForModel(Model $model)
 * @see FilterInstance
 * @see \Mtc\Filter\Filter
 *
 */
class Filter extends Facade
{
    /**
     * Define the facade accessor
     *
     * @return string
     */
    protected static function getFacadeAccessor(): string
    {
        return 'product-filter';
    }
}
