<?php

namespace Mtc\Events\Http\Presenters;

use Illuminate\Contracts\Support\Arrayable;
use Mtc\Events\EventCategory;

/**
 * Class OrderShipmentBoxUrlPresenter
 *
 * @package Mtc\Events
 */
class EventCategoryUrlPresenter implements Arrayable
{
    /**
     * @var EventCategory
     */
    protected $category;

    /**
     * OrderShipmentBoxUrlPresenter constructor.
     *
     * @param EventCategory $box
     */
    public function __construct(EventCategory $category)
    {
        $this->category = $category;
    }

    /**
     * Accessor
     *
     * @param $key
     * @return mixed
     */
    public function __get($key)
    {
        if (method_exists($this, $key)) {
            return $this->$key();
        }

        return $this->$key;
    }

    /**
     * Add support for conversion to array
     *
     * @return array
     */
    public function toArray()
    {
        return [
            'toggle_active' => $this->toggleActive(),
            'update' => $this->update(),
            'destroy' => $this->destroy()
        ];
    }

    /**
     * Update route
     *
     * @return string
     */
    public function update()
    {
        return route('admin.events.categories.update', [$this->category->id]);
    }

    /**
     * Destroy route
     *
     * @return string
     */
    public function destroy()
    {
        return route('admin.events.categories.destroy', [$this->category->id]);
    }

    /**
     * Toggle active state
     *
     * @return string
     */
    public function toggleActive()
    {
        return route('admin.events.categories.toggle-active', [$this->category->id]);
    }

}
