<?php

use Illuminate\Routing\Router;
use Mtc\Events\Http\Controllers\EventCategoryAdminController;
use Mtc\Events\Http\Controllers\EventTemplateController;
use Mtc\Events\Http\Controllers\EventAdminController;
use Mtc\Members\Http\Middleware\LoggedInMember;
use Mtc\Events\Http\Controllers\MyTicketsController;
use Mtc\Events\Http\Controllers\TicketAdminController;

/** @var Router $router */

$router->get(config('events.public_url_slug'), [ config('events.public_controller'), 'index' ])->name('events.index');
$router->get(config('events.public_url_slug') . '/{event}', [ config('events.public_controller'), 'show' ])->name('events.show');


$router->group([
    'prefix' => '/members/',
    'as' => 'members.',
    'middleware' => LoggedInMember::class,
], function (Router $router) {
    $router->get('tickets', [ MyTicketsController::class, 'index' ])->name('tickets.index');
    $router->get('tickets/{ticket}/download', [ MyTicketsController::class, 'download' ])->name('tickets.download');

});

$router->group([
    'prefix' => '/admin',
    'as' => 'admin.',
    'middleware' => [
        'auth'
    ],
], function (Router $router) {
    $router->group([
        'as' => 'events.'
    ], function (Router $router) {
        $router->post('events/{category}/toggle-active', [EventCategoryAdminController::class, 'togglePublished'])->name('categories.toggle-active');
        $router->resource('events/categories', EventCategoryAdminController::class)
            ->except([
                'show',
                'create',
                'edit',
            ]);
    });

    $router->get('events/templates', [ EventTemplateController::class, 'index' ]);
    $router->get('events/templates/email', [ EventTemplateController::class, 'email'])->name('events.preview-email');
    $router->get('events/templates/html-ticket', [ EventTemplateController::class, 'htmlTicket'])->name('events.preview-ticket-html');
    $router->get('events/templates/pdf-ticket', [ EventTemplateController::class, 'pdfTicket'])->name('events.preview-ticket-pdf');
    $router->put('events/tickets/{ticket}/mark-processed', [TicketAdminController::class, 'redeem'])->name('tickets.mark-processed');
    $router->delete('events/tickets/{ticket}/mark-processed', [TicketAdminController::class, 'destroy'])->name('tickets.destroy');

    $router->get('events/{event}/tickets', [ TicketAdminController::class, 'index'])->name('events.list-tickets');
    $router->resource('events', EventAdminController::class)
        ->except([
            'show'
        ]);
});