<?php

namespace Mtc\Events\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Storage;
use Mtc\Events\Ticket;

/**
 * Class TicketEmail
 *
 * @package Mtc\Events\Mail
 */
class TicketEmail extends Mailable
{
    use Queueable;
    use SerializesModels;

    /**
     * @var Ticket
     */
    protected $tickets;


    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($tickets)
    {
        $this->tickets = $tickets;
        $site_name = Config::get('app.name');
        $this->subject("Your {$site_name} Event Ticket(s)");
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $mail = $this->view('events::mail.empty', [
            'html' => template('events/emails/ticket_confirmation.twig', [
                'tickets' => $this->tickets
            ])
        ]);

        foreach ($this->tickets as $ticket) {
            /** @var Ticket $ticket */

            if (Storage::exists($ticket->getTicketFileLocation())) {
                $mail->attachFromStorage($ticket->getTicketFileLocation(), $ticket->getTicketFilename(), [
                    'mime' => 'application/pdf'
                ]);
            }
        }
    }
}
