<?php

namespace Mtc\Events\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Events\Event;
use Mtc\Events\Ticket;

/**
 * Class TicketAdminController
 *
 * @package Mtc\Events
 */
class TicketAdminController extends Controller
{
    /**
     * List view
     *
     * @param Request $request
     * @param Event $event
     * @return mixed
     */
    public function index(Request $request, Event $event)
    {
        if ($request->wantsJson()) {
            return $event->tickets()
                ->withTrashed()
                ->get();
        }

        $this->page_meta['title'] = 'Event Tickets';
        return template('admin/events/tickets.twig', [
            'page_meta' => $this->page_meta,
            'event' => $event,
            'tickets' => $event->tickets()
                ->withTrashed()
                ->get()
        ]);
    }

    /**
     * Process ticket redemption
     *
     * @param Ticket $ticket
     * @return \Illuminate\Http\RedirectResponse
     */
    public function redeem(Ticket $ticket)
    {
        $ticket->redeemed_at = Carbon::now();
        $ticket->save();

        return back()->with('success', 'Ticket updated');
    }

    /**
     * Cancel a ticket
     *
     * @param Ticket $ticket
     * @return \Illuminate\Http\RedirectResponse
     * @throws \Exception
     */
    public function destroy(Ticket $ticket)
    {
        $ticket->ticketEvent()->increment('available_ticket_count');
        $ticket->delete();
        return back()->with('success', 'Ticket Cancelled');
    }
}
