<?php

namespace Mtc\Enquiries\Seeds;

use Illuminate\Database\Seeder;

class EnquiryAdminMenuSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $shop_menu = \Mtc\Core\Admin\Menu::query()
            ->firstOrCreate([
                'title' => 'Reports'
            ], [
                'icon' => 'fa fa-chart-bar'
            ]);

        if ($shop_menu->id) {
            $shop_sub_menu = self::getShopSubMenu();
            foreach ($shop_sub_menu as $sub_menu) {
                $roles = $sub_menu['roles'] ?? [];
                unset($sub_menu['roles']);
                $child = $shop_menu->children()->create($sub_menu);
                \Mtc\Core\Admin\Menu::grantMenuPermissionToRole($child, $roles);
            }
        }
    }

    /**
     * Get admin menu (shop submenu) data
     *
     * @return array
     */
    protected function getShopSubMenu(): array
    {
        return [
            [
                'title' => 'Enquiries',
                'path' => '/admin/enquiries',
                'activePath' => '/admin/enquiries',
                'constant' => '',
                'order' => 0,
                'roles' => [
                    'Administrator'
                ],
            ],
        ];
    }
}
