<?php

namespace Mtc\Enquiries\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Mtc\Core\Admin\User;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Enquiries\Contracts\EnquiryRepositoryContract;

class EnquiryController extends Controller
{
    public function index(Request $request, EnquiryRepositoryContract $repository)
    {
        $this->page_meta['title'] = __('enquiries::enquiries.enquiries');
        return template('admin/enquiries/index.twig', [
            'page_meta' => $this->page_meta,
            'statuses' => $repository->getStatuses(),
            'enquiries' => $repository->getList($request)
        ]);
    }

    public function show($enquiry_id, EnquiryRepositoryContract $repository)
    {
        $users = User::query()
            ->when(in_array(config('app.env'), ['demo', 'production']), function ($query) {
                $query->whereDoesntHave('roles', function ($query) {
                    $query->where('name', 'mtc');
                });
            })
            ->pluck('name', 'id')
            ->prepend(__('enquiries::enquiries.select_user'));

        $this->page_meta['title'] = __('enquiries::enquiries.view_enquiry');
        return template('admin/enquiries/show.twig', [
            'page_meta' => $this->page_meta,
            'enquiry' => $repository->find($enquiry_id),
            'users' => $users,
            'statuses' => $repository->getStatuses()
        ]);
    }

    public function assign(Request $request, $enquiry_id, EnquiryRepositoryContract $repository)
    {
        $this->validate($request, [
            'user_id' => [
                'required',
                'exists:admin_users,id'
            ]
        ]);

        $repository->assign($enquiry_id, $request->input('user_id'));
        $message = 'Assigned to ' . User::find($request->input('user_id'))->name;
        $repository->addNote($enquiry_id, $message, Auth::id());

        session()->flash('success', __('enquiries::enquiries.assigned'));
        return back();
    }

    public function setStatus(Request $request, $enquiry_id, EnquiryRepositoryContract $repository)
    {
        $this->validate($request, [
            'status' => [
                'required'
            ]
        ]);

        $repository->setStatus($enquiry_id, $request->input('status'));
        $message = 'Updated Status to ' . config('enquiries.statuses.' . $request->input('status'));
        $repository->addNote($enquiry_id, $message, Auth::id());

        session()->flash('success', __('enquiries::enquiries.status_updated'));
        return back();
    }

    public function addNote(Request $request, $enquiry_id, EnquiryRepositoryContract $repository)
    {
        $this->validate($request, [
            'note' => [
                'required'
            ]
        ]);

        $repository->addNote((int)$enquiry_id, $request->input('note'), Auth::id());
        session()->flash('success', __('enquiries::enquiries.note_added'));
        return back();
    }
}
