<?php

namespace Mtc\Enquiries;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Route;
use Mtc\Enquiries\Contracts\EnquiryRepositoryContract;

class EnquiryProvider extends RouteServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__) . '/config/enquiries.php', 'enquiries');
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/migrations');
        $this->loadTranslationsFrom(dirname(__DIR__) . '/resources/lang', 'enquiries');
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        $this->app->bind(EnquiryRepositoryContract::class, Config::get('enquiries.repository'));
        app('twig_loader')->addPath(dirname(__DIR__) . '/resources/templates');

        parent::boot();
    }

    public function map()
    {
        Route::middleware('web')->group(dirname(__DIR__) . '/routes/web.php');
    }
}
