<?php

namespace Mtc\Enquiries;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Mtc\Core\Admin\User;
use Mtc\Shop\Item;

class EnquiryNote extends Model
{
    protected $table = 'enquiry_notes';

    protected $fillable = [
        'user_id',
        'enquiry_id',
        'note',
    ];

    public function enquiry(): BelongsTo
    {
        return $this->belongsTo(Enquiry::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
