<?php

namespace Mtc\Enquiries;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Facades\Config;
use Mtc\Core\Admin\User;
use Mtc\Shop\Item;

class Enquiry extends Model
{
    protected $fillable = [
        'name',
        'status_id',
        'user_id',
        'email',
        'data',
    ];


    protected $casts = [
        'data' => 'array',
        'created_at' => 'datetime',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function notes(): HasMany
    {
        return $this->hasMany(EnquiryNote::class)->latest();
    }

    public function getStatusAttribute(): string
    {
        return Config::get('enquiries.statuses.' . $this->attributes['status_id']);
    }
}
