<?php

namespace Mtc\Enquiries\Contracts;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Http\Request;
use Mtc\Enquiries\Enquiry;

interface EnquiryRepositoryContract
{
    public function getList(Request $request): LengthAwarePaginator;

    public function getStatuses(): array;

    public function find(int $id): Enquiry;

    public function create(string $name, string $email, array $data);

    public function assign(int $id, int $user_id): bool;

    public function setStatus(int $id, int $status_id): bool;

    public function addNote(int $id, string $note, int $user_id);
}
