<?php

use Illuminate\Routing\Router;

/** @var Router $router */

$router->group([
    'middleware' => ['auth'],
    'prefix' => 'admin/',
], function (Router $router) {
    /** @see \Mtc\Enquiries\Http\Controllers\EnquiryController */
    $router->resource('enquiries', config('enquiries.controller'))->only(['index', 'show']);
    $router->post('enquiries/{enquiry}/assign', [config('enquiries.controller'), 'assign'])->name('enquiries.assign');
    $router->post('enquiries/{enquiry}/set-status', [config('enquiries.controller'), 'setStatus'])->name('enquiries.set-status');
    $router->post('enquiries/{enquiry}/add-note', [config('enquiries.controller'), 'addNote'])->name('enquiries.add-note');
});