<?php

namespace Mtcmedia\EncryptionModule\Console;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Config;
use Mtcmedia\EncryptionModule\Support\ModelEncryptor;

class EncryptModels extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'encryption:encrypt {model? : Fully qualified model class name} {--chunk= : Override chunk size}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Encrypt attributes for one or more models that use OptionalEncrypted casts.';

    public function handle(): int
    {
        $chunkSize = $this->option('chunk');
        $chunkSize = $chunkSize !== null ? (int) $chunkSize : null;

        $model = $this->argument('model');
        if ($model) {
            $this->encryptModel($model, $chunkSize);
            return self::SUCCESS;
        }

        $models = Config::get('encryption-module.models', []);
        if (empty($models)) {
            $this->info('No models registered in config/encryption-module.php.');
            return self::SUCCESS;
        }

        foreach ($models as $registeredModel) {
            $this->encryptModel($registeredModel, $chunkSize);
        }

        return self::SUCCESS;
    }

    private function encryptModel(string $model, ?int $chunkSize): void
    {
        if (!class_exists($model)) {
            $this->error("Model {$model} does not exist.");
            return;
        }

        $this->line("Encrypting {$model}...");

        try {
            ModelEncryptor::encrypt($model, $chunkSize);
            $this->info("✓ Completed {$model}");
        } catch (\Throwable $exception) {
            $this->error("Failed encrypting {$model}: {$exception->getMessage()}");
        }
    }
}
