<?php

namespace App\Console\Commands;

use App\Src\Encryption;
use Illuminate\Console\Command;

class EncryptDbFields extends Command
{
    protected $signature = 'encryption:run';

    protected $description = 'Encrypts all fields marked as "encrypted" in the database.';

    public function handle(): int
    {
        foreach (Encryption::$modelsWithEncryption as $model) {
            try {
                Encryption::encrypt($model);
            } catch (\Throwable $exception) {
                $this->error("Failed encrypting {$model}: {$exception->getMessage()}");
            }
        }

        $this->info('Encryption completed.');

        return self::SUCCESS;
    }
}
