<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Global Encryption Toggle
    |--------------------------------------------------------------------------
    |
    | Controls whether the module encrypts attribute values and file payloads.
    | Falls back to the legacy `encryption.enabled` flag when omitted.
    |
    */
    'enabled' => env('ENCRYPTION_ENABLED', true),

    /*
    |--------------------------------------------------------------------------
    | Registered Models
    |--------------------------------------------------------------------------
    |
    | A list of Eloquent model class names that contain OptionalEncrypted casts.
    | Console commands can iterate over this list when you do not pass a model
    | explicitly.
    |
    */
    'models' => [
        // e.g. \App\Models\User::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Default Chunk Size
    |--------------------------------------------------------------------------
    |
    | Number of records processed per database chunk when encrypting/decrypting.
    |
    */
    'chunk_size' => env('ENCRYPTION_CHUNK_SIZE', 2000),

    /*
    |--------------------------------------------------------------------------
    | Hash Column Suffix
    |--------------------------------------------------------------------------
    |
    | When an attribute is marked searchable, the module generates deterministic
    | hashes to the column named "<attribute><suffix>".
    |
    */
    'hash_suffix' => '_hash',

    /*
    |--------------------------------------------------------------------------
    | File Encryption Settings
    |--------------------------------------------------------------------------
    |
    | Control how FileEncrypter stores blob data.
    |
    */
    'file' => [
        // Suffix appended to encrypted files, such as ".enc".
        'suffix' => env('ENCRYPTION_FILE_SUFFIX', '.enc'),

        // Allow overriding default disk when encrypting files (optional).
        'disk' => env('ENCRYPTION_FILE_DISK'),
    ],
];
