<?php

namespace Mtc\Crm\Contracts;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Config;
use Mtc\Crm\Factories\FormFactory;
use Mtc\Crm\Traits\ModelSortAndFilter;

/**
 * @property Collection $sections
 * @property Collection $questions
 * @property Collection $actions
 */
abstract class FormModel extends Model
{
    use SoftDeletes;
    use HasFactory;
    use ModelSortAndFilter;

    /**
     * @var string
     */
    protected $table = 'forms';

    /**
     * @var string[]
     */
    protected $fillable = [
        "name",
        "type_id",
        "is_active",
        "active_from",
        "active_until",
        "data",
        "notify_customer_on_received_enquiry",
        "customer_notification_subject",
        "customer_notification_content",
        "confirmation_message",
        "success_message",
        "initial_status_id",
        "initial_assignee",
    ];

    protected $casts = [
        'data' => 'array',
    ];

    /**
     * Model Factory
     *
     * @return FormFactory
     */
    protected static function newFactory()
    {
        return FormFactory::new();
    }

    /**
     * Relationship with questions
     *
     * @return HasMany
     */
    public function questions(): HasMany
    {
        return $this->hasMany(Config::get('crm.form_question_model'))
            ->orderBy('order');
    }

    /**
     * Relationship with sections
     *
     * @return HasMany
     */
    public function sections(): HasMany
    {
        return $this->hasMany(Config::get('crm.form_section_model'))
            ->orderBy('order');
    }

    /**
     * Relationship with form actions
     *
     * @return HasMany
     */
    public function actions(): HasMany
    {
        return $this->hasMany(Config::get('crm.form_action_model'));
    }
}
