<?php

namespace Mtc\Crm\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\Crm\Models\Enquiry;
use Mtc\Crm\Models\EnquiryStatus;
use Mtc\Crm\Models\EnquiryStatusHistory;

class EnquiryStatusHistoryFactory extends Factory
{
    protected $model = EnquiryStatusHistory::class;

    /**
     * Define the model's default state.
     *
     * @return array
     * @throws \Exception
     */
    public function definition()
    {
        $from_customer = random_int(0, 1);
        return [
            'enquiry_id' => Enquiry::query()->inRandomOrder()->first()->id,
            'status_id' => EnquiryStatus::query()->inRandomOrder()->first()->id,
            'user_id' => $from_customer ? random_int(1, 10) : null,
            'from_customer' => $from_customer,
        ];
    }
}
