<?php

namespace Mtc\Crm\Contracts;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Config;
use Mtc\Crm\Factories\FormActionFactory;

abstract class FormActionModel extends Model
{
    use HasFactory;
    use SoftDeletes;

    /**
     * @var string
     */
    protected $table = 'form_actions';

    /**
     * @var string[]
     */
    protected $fillable = [
        'action_name',
        'fields',
    ];

    /**
     * Cast attributes to types
     *
     * @var string[]
     */
    protected $casts = [
        'fields' => 'array'
    ];

    /**
     * Model Factory
     *
     * @return FormActionFactory
     */
    protected static function newFactory()
    {
        return FormActionFactory::new();
    }

    /**
     * Relationship with questions
     *
     * @return BelongsTo
     */
    public function form(): BelongsTo
    {
        return $this->belongsTo(Config::get('crm.form_model'));
    }
}
