<?php

namespace Mtc\Crm\Contracts;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Facades\Config;
use Mtc\Crm\Factories\EnquiryStatusFactory;

abstract class EnquiryStatusModel extends Model
{
    use HasFactory;

    /**
     * @var string
     */
    protected $table = 'enquiry_statuses';

    /**
     * @var string[]
     */
    protected $fillable = [
        'name',
        'is_initial',
        'is_final',
        'badge_colour'
    ];

    /**
     * Cast attributes to types
     *
     * @var string[]
     */
    protected $casts = [
        'is_final' => 'boolean',
    ];

    /**
     * Model factory
     *
     * @return EnquiryStatusFactory
     */
    protected static function newFactory()
    {
        return EnquiryStatusFactory::new();
    }

    /**
     * Relationship with enquiries that have this status
     *
     * @return HasMany
     */
    public function enquiries(): HasMany
    {
        return $this->hasMany(Config::get('crm.enquiry_model'), 'status_id');
    }
}
