<?php

namespace Mtc\Crm\Tests\Unit;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\Crm\Facades\EnquiryData;
use Mtc\Crm\Models\EnquiryType;
use Mtc\Crm\Tests\TestCase;

class EnquiryTypeTest extends TestCase
{
    use RefreshDatabase;

    public function testGetModel()
    {
        $this->assertInstanceOf(EnquiryType::class, EnquiryData::getTypeModel());
    }

    public function testGetTypes()
    {
        $type = EnquiryType::query()->create([ 'name' => 'hello' ]);
        $type2 = EnquiryType::query()->create([ 'name' => 'world' ]);

        $this->assertEquals(2, EnquiryData::getTypes()->total());
        $this->assertTrue(EnquiryData::getTypes()->first()->is($type));
    }

    public function testFindType()
    {
        $type = EnquiryType::query()->create([ 'name' => 'hello' ]);

        $this->assertTrue(EnquiryData::findType($type->id)->is($type));

        $this->expectException(ModelNotFoundException::class);
        EnquiryData::findType(PHP_INT_MAX);
    }

    public function testAddType()
    {
        EnquiryData::addType('hello-world');
        $this->assertTrue(EnquiryType::query()->where('name', 'hello-world')->exists());
    }

    public function testUpdateType()
    {
        $enquiry = EnquiryData::addType('hello-world');
        $this->assertTrue(EnquiryType::query()->where('name', 'hello-world')->exists());
        EnquiryData::updateType($enquiry->id, 'lorem-ipsum');
        $this->assertTrue(EnquiryType::query()->where('name', 'lorem-ipsum')->where('id', $enquiry->id)->exists());
    }

    public function testRemoveType()
    {
        $enquiry = EnquiryData::addType('hello-world');
        $this->assertTrue(EnquiryType::query()->where('name', 'hello-world')->exists());
        $this->assertTrue(EnquiryData::removeType($enquiry->id));
        $this->expectException(ModelNotFoundException::class);
        EnquiryData::findType($enquiry->id);
    }
}
