<?php

namespace Mtc\Crm\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Str;

class FormViewResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request)
    {
        $this->resource->available_actions = $this->getAvailableActions();
        $this->resource->load([
            'sections.questions',
        ]);

        $this->resource->actions = $this->resource->actions()
            ->get()
            ->keyBy(fn($data) => $data->action_name)
            ->map(fn($data) => $data->fields);

        return parent::toArray($request);
    }

    /**
     * Get list of available actions on forms
     *
     * @return \Illuminate\Support\Collection
     */
    protected function getAvailableActions()
    {
        return collect(config('crm.form_actions'))
            ->map(fn($class, $key) => [
                'name' => Str::title(str_replace('-', ' ', $key)),
                'question_fields' => collect(App::make($class)->formQuestionDataFields() ?? []),
                'fields' => collect(App::make($class)->formAdditionalDataFields() ?? [])
                    ->put('enabled', [
                        'type' => 'checkbox',
                        'label' => 'Enabled',
                    ]),
            ]);
    }
}
