<?php

namespace Mtc\Crm\Actions;

use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Mtc\Crm\Contracts\EnquiryAction;
use Mtc\Crm\Contracts\EnquiryActionModel;
use Mtc\Crm\Contracts\EnquiryModel;
use Mtc\Crm\Mail\NewEnquiryMail;

class SendCopyViaMail implements EnquiryAction
{
    protected EnquiryActionModel $action;

    /**
     * Data fields to add to form
     *
     * @return array
     */
    public function formAdditionalDataFields(): array
    {
        return [
            'recipient' => [
                'type' => 'text',
                'validation' => [
                    'required',
                    'email',
                ],
                'label' => 'Send Email To'
            ],
            'enquiry_subject' => [
                'type' => 'text',
                'validation' => 'required',
                'label' => 'Enquiry Email Subject',
            ],
            'enquiry_content' => [
                'type' => 'textarea',
                'label' => 'Enquiry Email Message',
            ],
        ];
    }

    /**
     * Data fields to add to form
     *
     * @return array
     */
    public function formQuestionDataFields(): array
    {
        return [];
    }

    /**
     * Handle the action
     *
     * @param EnquiryActionModel $action
     * @param EnquiryModel $enquiry
     * @return bool
     */
    public function handle(EnquiryActionModel $action, EnquiryModel $enquiry): ?bool
    {
        $this->action = $action;

        $recipient = $this->action->data['recipient'] ?? '';
        if (!empty($recipient)) {
            try {
                $class = config('crm.new_enquiry_email');
                Mail::to($recipient)->send(new $class($enquiry));
                return true;
            } catch (\Exception $exception) {
                Log::warning($exception->getMessage());
            }
        }
        return false;
    }

    /**
     * Message when successfully processed
     *
     * @return string
     */
    public function successDetails(): string
    {
        return "Copy sent to " . $this->action->data['recipient'];
    }

    /**
     * Message when failed to process
     *
     * @return string
     */
    public function failureReason(): string
    {
        if (empty($this->action->data['recipient'])) {
            return 'no recipient specified';
        }
        return 'issue sending mail';
    }
}
