<?php

namespace Mtc\Crm\Contracts;

interface EnquiryAction
{
    /**
     * Data fields to add to form
     *
     * @return array
     */
    public function formAdditionalDataFields(): array;

    /**
     * Data fields to add to questions
     *
     * @return array
     */
    public function formQuestionDataFields(): array;

    /**
     * Handle the action
     *
     * @param EnquiryActionModel $action
     * @param EnquiryModel $enquiry
     * @return bool
     */
    public function handle(EnquiryActionModel $action, EnquiryModel $enquiry): ?bool;

    /**
     * Message when successfully processed
     *
     * @return string
     */
    public function successDetails(): string;

    /**
     * Message when failed to process
     *
     * @return string
     */
    public function failureReason(): string;
}
