<?php

namespace Mtc\Crm\Http\Controllers;

use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Mtc\Crm\Contracts\Customer;
use Mtc\Crm\Contracts\EnquiryTypeModel;
use Mtc\Crm\CustomerRepository;
use Mtc\Crm\Facades\EnquiryData;
use Mtc\Crm\Http\Requests\CreateCustomerRequest;
use Mtc\Crm\Http\Requests\EnquiryTypeRequest;
use Mtc\Crm\Http\Resources\CustomerView;

class CustomerController
{
    use ValidatesRequests;

    public function index(Request $request, CustomerRepository $repository)
    {
        return $repository->getList($request);
    }

    public function store(CreateCustomerRequest $request, Customer $customer): JsonResource
    {
        $resource = config('crm.customer_view_resource');
        $customer = $customer->newQuery()->create([
            'email' => $request->input('name')
        ]);
        return new $resource($customer);
    }

    public function show(Customer $customer): JsonResource
    {
        $resource = config('crm.customer_view_resource');
        return new $resource($customer);
    }

    public function update(Request $request, Customer $customer): JsonResource
    {
        $resource = config('crm.customer_view_resource');
        $customer->update($request->input());
        $customer->refresh();
        return new $resource($customer);
    }

    public function destroy(Customer $customer): bool
    {
        return $customer->delete();
    }

    public function addNote(Request $request, Customer $customer)
    {
        $customer->notes()->create([
            'author_id' => Auth::id(),
            'details' => $request->input('details'),
        ]);

        return $customer->notes()
            ->latest()
            ->get()
            ->map(fn($note) => [
                'author' => $note->author?->name,
                'type' => $note->type,
                'severity' => $note->severity,
                'when' => $note->created_at->format('d/m/Y H:i'),
                'details' => $note->details,
            ]);
    }
}
