<?php

namespace Mtc\Crm\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\Crm\Models\Enquiry;

class EnquiryFactory extends Factory
{
    /**
     * Model
     *
     * @var string
     */
    protected $model = Enquiry::class;

    /**
     * Define the model's default state.
     *
     * @return array
     * @throws \Exception
     */
    public function definition()
    {
        return [
            'ingested_at' => random_int(0, 1) ? Carbon::now()->subMinutes(random_int(0, 2000)) : null,
            'form_id' => random_int(1, 50),
            'email' => $this->faker->safeEmail,
            'submitter_id' => null,
            'submitter_type' => null,
            'type_id' => random_int(1, 10),
            'status_id' => random_int(1, 10),
            'title' => $this->faker->sentence,
            'message' => $this->faker->sentence,
            'details' => [],
            'data' => [],
            'assigned_user_id' => random_int(0, 10) ?: null,
            'customer_id' => random_int(0, 10) ?: null,
        ];
    }
}
