<?php

namespace Mtc\Crm\Http\Controllers;

use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;
use Mtc\Crm\Contracts\FormModel;
use Mtc\Crm\Facades\Forms;
use Mtc\Crm\Http\Requests\FormUpdateRequest;
use Mtc\Crm\Http\Resources\FormList;
use Mtc\Crm\Http\Resources\FormViewResource;

class FormController
{
    use ValidatesRequests;

    /**
     * List forms on site
     *
     * @param Request $request
     * @param FormModel $forms
     * @return FormList
     */
    public function index(Request $request, FormModel $forms): FormList
    {
        $resource = Config::get('crm.form_list_resource');
        return new $resource(
            $forms->newQuery()
                ->setSortBy($request->input('sort_by', 'id_desc'))
                ->setFilters($request->input('filters', []))
                ->paginate()
        );
    }

    /**
     * Show Form details
     *
     * @param FormModel $form
     * @return FormViewResource
     */
    public function show(FormModel $form): FormViewResource
    {
        $resource = Config::get('crm.form_view_resource');
        return new $resource($form);
    }

    /**
     * Update Form details
     *
     * @param FormUpdateRequest $request
     * @param FormModel $form
     * @return FormViewResource
     */
    public function update(FormUpdateRequest $request, FormModel $form): FormViewResource
    {
        Forms::update($request, $form);
        $resource = Config::get('crm.form_view_resource');
        return new $resource($form->refresh());
    }
}
