<?php

namespace Mtc\Crm\Http\Controllers;

use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;
use Mtc\Crm\Contracts\FormModel;
use Mtc\Crm\Facades\Forms;
use Mtc\Crm\Http\Requests\FormUpdateRequest;
use Mtc\Crm\Http\Resources\FormList;
use Mtc\Crm\Http\Resources\FormViewResource;

class FormController
{
    use ValidatesRequests;

    public function index(Request $request, FormModel $forms): FormList
    {
        $resource = Config::get('crm.form_list_resource');
        return new $resource(
            $forms->newQuery()
                ->setSortBy($request->input('sort_by', 'id_desc'))
                ->setFilters($request->input('filters', []))
                ->paginate()
        );
    }

    public function store(Request $request): FormViewResource
    {
        $form = Forms::store($request);
        $resource = Config::get('crm.form_view_resource');
        return new $resource($form);
    }

    public function copy(Request $request, FormModel $form): FormViewResource
    {
        $copy = Forms::copy($form, $request->input('title'), $request->input('with_content', false));
        $resource = Config::get('crm.form_view_resource');
        return new $resource($copy);
    }

    public function show(FormModel $form): FormViewResource
    {
        $resource = Config::get('crm.form_view_resource');
        return new $resource($form);
    }

    public function update(FormUpdateRequest $request, FormModel $form): FormViewResource
    {
        Forms::update($request, $form);
        $resource = Config::get('crm.form_view_resource');
        return new $resource($form->refresh());
    }

    public function destroy(Request $request, FormModel $form): FormList
    {
        Forms::delete($form);
        return $this->index($request, $form);
    }
}
