<?php

namespace Mtc\Crm\Http\Controllers;

use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Support\Collection;
use Mtc\Crm\Contracts\EnquiryTypeModel;
use Mtc\Crm\Facades\EnquiryData;
use Mtc\Crm\Http\Requests\EnquiryTypeRequest;

class EnquiryTypeController
{
    use ValidatesRequests;

    /**
     * List all available enquiry types
     *
     * @return Collection
     */
    public function index(): Collection
    {
        return  EnquiryData::getTypes();
    }

    /**
     * Store a new enquiry type
     *
     * @param EnquiryTypeRequest $request
     * @return EnquiryTypeModel
     */
    public function store(EnquiryTypeRequest $request): EnquiryTypeModel
    {
        return EnquiryData::addType($request->input('name'));
    }

    /**
     * Display enquiry type details
     *
     * @param int $id
     * @return EnquiryTypeModel
     */
    public function show(int $id): EnquiryTypeModel
    {
        return EnquiryData::findType($id);
    }

    /**
     * Update details of an enquiry type
     *
     * @param EnquiryTypeRequest $request
     * @param $id
     * @return boolean
     */
    public function update(EnquiryTypeRequest $request, $id): bool
    {
        return EnquiryData::updateType($id, $request->input('name'));
    }

    /**
     * Remove an enquiry type
     *
     * @param $id
     * @return bool
     */
    public function destroy($id): bool
    {
        return EnquiryData::removeType($id);
    }
}
