<?php

namespace Mtc\Crm\Http\Controllers;

use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Mtc\Crm\Contracts\FormModel;
use Mtc\Crm\Facades\Forms;
use Mtc\Crm\Http\Requests\FormUpdateRequest;
use Mtc\Crm\Http\Resources\FormList;
use Mtc\Crm\Http\Resources\FormViewResource;

class FormController
{
    use ValidatesRequests;

    /**
     * List forms on site
     *
     * @param Request $request
     * @param FormModel $forms
     * @return FormList
     */
    public function index(Request $request, FormModel $forms): FormList
    {
        return new FormList($forms->newQuery()->paginate());
    }

    /**
     * Show Form details
     *
     * @param FormModel $form
     * @return FormViewResource
     */
    public function show(FormModel $form): FormViewResource
    {
        return new FormViewResource($form);
    }

    /**
     * Update Form details
     *
     * @param FormUpdateRequest $request
     * @param FormModel $form
     * @return FormViewResource
     */
    public function update(FormUpdateRequest $request, FormModel $form): FormViewResource
    {
        Forms::update($request, $form);
        return new FormViewResource($form->refresh());
    }
}
