<?php

namespace Mtc\Crm\Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\Crm\Models\EnquiryTag;
use Mtc\Crm\Tests\AsUser;
use Mtc\Crm\Tests\TestCase;

class EnquiryTagControllerTest extends TestCase
{
    use RefreshDatabase;
    use AsUser;

    public function testListTags()
    {
        $this->asUser();
        $response = $this->get(route('enquiry-tags.index'));

        $this->assertEquals(200, $response->status());
        $body = $response->getData(true);
        $this->assertEquals(0, count($body));

        EnquiryTag::factory()->create(['name' => 'foo']);
        EnquiryTag::factory()->create(['name' => 'baz']);
        EnquiryTag::factory()->create(['name' => 'bar']);

        $response = $this->get(route('enquiry-tags.index'));

        $body = $response->getData(true);
        $this->assertEquals(3, count($body));
    }

    public function testShowTag()
    {
        $this->asUser();
        $tag = EnquiryTag::factory()->create([
            'name' => 'foo',
        ]);

        $response = $this->get(route('enquiry-tags.show', $tag));

        $body = $response->getData();
        $this->assertEquals('foo', $body->name);
    }

    public function testAddTag()
    {
        $this->asUser();
        $response = $this->postJson(route('enquiry-tags.store'), [
            'name' => 'foo'
        ]);

        $this->assertEquals(201, $response->getStatusCode());
        $data = $response->getData();
        $tag = EnquiryTag::query()->find($data->id);

        $this->assertInstanceOf(EnquiryTag::class, $tag);
        $this->assertEquals($tag->id, $data->id);
        $this->assertEquals('foo', $tag->name);
    }

    public function testUpdateTag()
    {
        $this->asUser();
        $tag = EnquiryTag::factory()->create(['name' => 'foo']);

        $response = $this->put(route('enquiry-tags.update', $tag->id), [
            'name' => 'baz-bar',
        ]);

        $this->assertEquals(200, $response->getStatusCode());
        $tag->refresh();

        $this->assertEquals('baz-bar', $tag->name);
    }

    public function testRemoveTag()
    {
        $this->asUser();
        $tag = EnquiryTag::factory()->create([
            'name' => 'foo',
        ]);

        $response = $this->delete(route('enquiry-tags.destroy', $tag));
        $this->assertEquals(200, $response->getStatusCode());

        $response = $this->get(route('enquiry-tags.show', $tag));
        $this->assertEquals(404, $response->getStatusCode());
    }

}
