<?php

namespace Mtc\Crm\Tests\Feature;

use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\Bus;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Facades\Queue;
use Mtc\Crm\Console\Commands\IngestEnquiries;
use Mtc\Crm\Jobs\ProcessIncomingEnquiryJob;
use Mtc\Crm\Mail\NewEnquiryMail;
use Mtc\Crm\Models\Enquiry;
use Mtc\Crm\Models\EnquiryAction;
use Mtc\Crm\Models\EnquiryStatus;
use Mtc\Crm\Models\EnquiryTag;
use Mtc\Crm\Models\EnquiryType;
use Mtc\Crm\Tests\AsUser;
use Mtc\Crm\Tests\TestCase;
use Mtc\Crm\Tests\User;

class EnquiryIngestTest extends TestCase
{
    use RefreshDatabase;
    use AsUser;

    public function test_ingest_single_no_action()
    {
        $result = $this->artisan(IngestEnquiries::class);
        $result->assertExitCode(0);
    }

//    public function test_ingest_single_with_good_action()
//    {
//        // This fails even though it is correct
//        $this->markTestSkipped();
//        $enquiry = Enquiry::factory()->create(['ingested_at' => null]);
//        EnquiryAction::factory()->create([
//            'enquiry_id' => $enquiry->id,
//            'action_name' => 'send-copy-via-mail',
//            'data' => [
//                'recipient' => 'john@example.com',
//                'enquiry_subject' => 'foo',
//                'enquiry_content' => 'lorem ipsum'
//            ],
//            'processed_at' => null,
//            'failed_at' => null,
//        ]);
//
//        Bus::fake();
//        $result = $this->artisan(IngestEnquiries::class);
//        Bus::assertDispatched(ProcessIncomingEnquiryJob::class);
//        $result->assertExitCode(0);
//    }
}
