<?php

namespace Mtc\Crm\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EnquiryList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request)
    {
        $this->resource
            ->each(function ($enquiry) {
                $enquiry->updated_time = $enquiry->updated_at->format('d/m/y H:i');
            });
        return parent::toArray($request);
    }
}
