<?php

namespace Mtc\Crm\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class CreateCustomerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            'name' => [
                'required',
                'email',
                'unique:customers,email',
            ],
        ];
    }

    public function attributes()
    {
        return [
            'name' => 'email',
        ];
    }

    public function messages()
    {
        return [
            'unique' => 'Account with such email already exists',
        ];
    }
}
