<?php

namespace Mtc\Crm\Http\Controllers;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Support\Collection;
use Mtc\Crm\Contracts\EnquiryTypeModel;
use Mtc\Crm\Facades\EnquiryData;
use Mtc\Crm\Http\Requests\EnquiryTypeRequest;
use Mtc\Crm\Http\Resources\EnquiryTypeResource;

class EnquiryTypeController
{
    use ValidatesRequests;

    /**
     * List all available enquiry types
     *
     * @return Collection
     */
    public function index(): LengthAwarePaginator
    {
        return  EnquiryData::getTypes();
    }

    /**
     * Store a new enquiry type
     *
     * @param EnquiryTypeRequest $request
     * @return EnquiryTypeModel
     */
    public function store(EnquiryTypeRequest $request): EnquiryTypeModel
    {
        return EnquiryData::addType($request->input('name'), $request->input('template_name'));
    }

    /**
     * Display enquiry type details
     *
     * @param int $id
     * @return EnquiryTypeModel
     */
    public function show(int $id): EnquiryTypeResource
    {
        return EnquiryData::getEnquiryTypeResource(EnquiryData::findType($id));
    }

    /**
     * Update details of an enquiry type
     *
     * @param EnquiryTypeRequest $request
     * @param $id
     * @return boolean
     */
    public function update(EnquiryTypeRequest $request, $id): bool
    {
        return EnquiryData::updateType(
            $id,
            $request->input('name'),
            $request->input('template_name'),
            $request->input() ?? []
        );
    }

    /**
     * Remove an enquiry type
     *
     * @param $id
     * @return bool
     */
    public function destroy($id): bool
    {
        return EnquiryData::removeType($id);
    }
}
