<?php

namespace Mtc\Crm\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\Crm\Models\EnquiryAnswer;

class EnquiryAnswerFactory extends Factory
{
    protected $model = EnquiryAnswer::class;

    /**
     * Define the model's default state.
     *
     * @return array
     * @throws \Exception
     */
    public function definition(): array
    {
        return [
            'enquiry_id' => random_int(1, 10),
            'question_id' => random_int(1, 50),
            'question_name' => $this->faker->words(3, true),
            'answer_value' => $this->faker->sentence(),
            'answer_array' => null,
            'answer_type' => 'text',
        ];
    }

    /**
     * Create an array type answer
     */
    public function array(): static
    {
        return $this->state(fn(array $attributes) => [
            'answer_value' => null,
            'answer_array' => $this->faker->words(3),
            'answer_type' => 'array',
        ]);
    }

    /**
     * Create a file type answer
     */
    public function file(): static
    {
        return $this->state(fn(array $attributes) => [
            'answer_value' => 'uploads/' . date('Y-M') . '/' . $this->faker->uuid() . '.pdf',
            'answer_array' => null,
            'answer_type' => 'file',
        ]);
    }
}
