<?php

namespace Mtc\Coupons\Seeds;

use Illuminate\Database\Seeder;

/**
 * Class CouponsSeeder
 * @package Mtc\MultiBuy\Seeds
 */
class CouponsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->seedMenu();
        $this->call(ShippingModifierSeeder::class);
    }

    /**
     * Seed Admin menu
     */
    public function seedMenu()
    {
        $shop_module_menu = \Mtc\Core\Admin\Menu::query()
            ->firstOrCreate([
                'title' => 'Sales'
            ], [
                'icon' => 'fas fa-shopping-cart',
            ]);

        if ($shop_module_menu->id) {
            $sub_menu_entries = $this->getSubMenu();
            foreach ($sub_menu_entries as $sub_menu) {
                $shop_module_menu->children()->create($sub_menu);
            }
        }
    }

    /**
     * Get Data for Admin Menu entries (Shop submenu)
     *
     * @return array
     */
    protected function getSubMenu()
    {
        return [
            [
                'title' => 'Coupons',
                'path' => '/admin/coupons/',
                'activePath' => 'admin/coupons/',
                'constant' => 'coupons.enabled',
                'icon' => null,
                'order' => 22,
            ]
        ];
    }
}
