<?php

namespace Mtc\Coupons\Restrictions;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;
use Mtc\Coupons\Coupon;

/**
 * Class ItemRestriction
 * @package Mtc\Coupons\Restrictions
 */
class ItemRestriction
{
    /**
     * @param Coupon $coupon
     * @param $item
     * @param $restriction
     * @param $restrictions_count
     * @return bool
     */
    public function validate(Coupon $coupon, $item, $restriction, $restrictions_count)
    {
        // Coupon doesn't have any restriction
        if (!$restrictions_count['excluded'] && !$restrictions_count['included']) {
            return false;
        }

        $purchasable_item = $item->purchasable->item ?: $item->purchasable;
        $check_item_restriction = $purchasable_item->id === $restriction->discountable_id;

        // Coupon contains only excluded restrictions
        if ($restrictions_count['excluded'] && !$restrictions_count['included']) {
            return !($check_item_restriction);
        }

        // Coupon contains only included restrictions
        if ($restrictions_count['included'] && !$restrictions_count['excluded']) {
            return $check_item_restriction;
        }

        // Coupon contains both included and excluded restrictions
        return $restriction->exclude ? !$check_item_restriction : $check_item_restriction;
    }
}
