<?php

namespace Mtc\Coupons;

use Illuminate\Support\Facades\File;
use Mtc\Coupons\Providers\CouponServiceProvider;
use Mtc\Coupons\Seeds\CouponsSeeder;
use Mtc\Foundation\Contracts\InstallableComponent;

/**
 * Class CouponInstaller
 *
 * @package Mtc\Coupons
 */
class CouponInstaller implements InstallableComponent
{
    /**
     * Define what needs to be published.
     * This should be formatted in following format:
     *
     * @return array
     */
    public function publish(): array
    {
        return [
            [
                '--provider' => CouponServiceProvider::class,
                '--tag' => 'assets'
            ]
        ];
    }

    /**
     * Provide a classname of seeder that should be called
     * In case of no seed required provide an empty string
     */
    public function seed(): string
    {
        return CouponsSeeder::class;
    }

    /**
     * List of npm packages and their version restrictions
     *
     * @return array
     */
    public function npmDependencies(): array
    {
        $package_json = json_decode(File::get(dirname(__DIR__) . '/package.json'), true);
        return $package_json['dependencies'] ?? [];
    }

    /**
     * Whether npm should be run to compile assets after installation has been done
     *
     * @return bool
     */
    public function shouldRunNpm(): bool
    {
        return true;
    }
}
