<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCouponsTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('template_id')->nullable()->index();
            $table->boolean('is_template')->nullable()->index();
            $table->string('name');
            $table->string('code')->unique();
            $table->date('valid_from')->nullable()->index();
            $table->date('valid_to')->nullable()->index();
            $table->integer('redemptions')->default(1)->index();
            $table->decimal('value', 10)->default(0);
            $table->string('type', 50)->nullable()->index();
            $table->unsignedTinyInteger('shipping_modifier')->nullable()->index();
            $table->decimal('min_basket_price', 10)->nullable()->index();
            $table->boolean('only_first_purchase')->nullable()->index();
            $table->unsignedTinyInteger('sale_restriction')->nullable()->index();
            $table->timestamps();
        });

        Schema::create('coupon_restrictions', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('coupon_id')->index();
            $table->morphs('discountable');
            $table->boolean('exclude')->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('coupons');
        Schema::dropIfExists('coupon_restrictions');
    }
}
