<?php

namespace Mtc\Coupons\Rules;

use Illuminate\Contracts\Validation\Rule;
use Mtc\Basket\Basket;
use Mtc\Coupons\Facades\Coupon;
use Mtc\Foundation\PostcodeValidationFactory;

/**
 * Class ValidPostcode
 *
 * @package Mtc\Foundation\Rules
 */
class ActiveCoupon implements Rule
{
    /**
     * @var Basket
     */
    protected $basket;

    /**
     * Create a new rule instance.
     *
     * @param Basket $basket
     * @return void
     */
    public function __construct(Basket $basket)
    {
        $this->basket = $basket;
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return Coupon::isRedeemable($value);
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return __('coupons::coupons.validation.not_active');
    }
}
