<?php

use Illuminate\Routing\Router;
use Mtc\Coupons\Http\Controllers\Admin\CouponController as AdminCouponController;
use Mtc\Coupons\Http\Controllers\CouponController;
use Mtc\Coupons\Http\Controllers\Admin\RestrictionController;

$router->group([
    'prefix' => '/admin',
    'middleware' => [
        'auth',
        'middleware' => 'permission:coupons'
    ]
], function (Router $router) {
    $router->get('coupons/{id}/restrictions/{restriction}', RestrictionController::class . '@index');
    $router->post('coupons/{id}/restrictions/{restriction}', RestrictionController::class . '@store');
    $router->delete('coupons/restrictions/{restriction_id}', RestrictionController::class . '@destroy');
    $router->post('coupons/restrictions/{restriction_id}/toggle-exclude', RestrictionController::class . '@toggleExclude');
    $router->get('coupons/{id}/restrictions/{restriction}/search', RestrictionController::class . '@search');

    $router->resource('coupons', AdminCouponController::class)->except([ 'show' ]);
});

$router->post('set-coupon', CouponController::class . '@store');