<?php

namespace Mtc\Coupons;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\App;
use Mtc\Basket\Item;
use Mtc\Coupons\Contracts\CouponRepositoryInterface;

/**
 * Class Validator
 *
 * Implements coupon validation and application
 * @package Mtc\Coupons
 */
class Validator
{
    /**
     * @var CouponRepositoryInterface
     */
    protected $coupon;

    /**
     * @var Model
     */
    protected $basket;

    /**
     * Validate the coupon
     *
     * @param string $code
     * @return bool
     */
    public function validate(string $code) : bool
    {
        $this->coupon = App::make(CouponRepositoryInterface::class);
        $this->coupon->findByCode($code);

        if (!$this->coupon->getModel() || !$this->coupon->isTypeEnabled()) {
            return false;
        }

        $this->basket = App::make('basket');
        return $this->coupon->isAvailable($this->basket);
    }
}
