<?php

namespace Mtc\Coupons\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Database\Eloquent\Relations\Relation;
use Mtc\Coupons\Facades\Coupon;
use Mtc\Coupons\Facades\Restriction;

/**
 * Class RestrictionController
 * @package Mtc\Coupons\Http\Controllers\Admin
 */
class RestrictionController extends Controller
{
    /**
     * Get restriction items
     *
     * @param Request $request
     * @param $coupon_id
     * @param $restriction_name
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request, $coupon_id, $restriction_name)
    {
        $restrictions = App::make('coupon-restriction')
            ->newQuery()
            ->with('discountable')
            ->where('discountable_type', $restriction_name)
            ->where('coupon_id', $coupon_id)
            ->get();

        return response()->json([
            'restrictions' => $restrictions
        ]);
    }

    /**
     * Store restriction
     *
     * @param Request $request
     * @param $coupon_id
     * @param $restriction_name
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Illuminate\Http\Response
     */
    public function store(Request $request, $coupon_id, $restriction_name)
    {
        if (!config('coupons.restrictions.items.' . $restriction_name) && !config('coupons.restrictions.basket.' . $restriction_name)) {
            return response('Restriction not found', 404);
        }

        $coupon = App::make('coupon')->find($coupon_id);
        $coupon->restrictions()->create([
            'discountable_id' => $request->input('item'),
            'discountable_type' => $restriction_name,
        ]);
    }

    /**
     * Destroy restriction
     *
     * @param Request $request
     * @param $restriction_id
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Illuminate\Http\Response
     */
    public function destroy(Request $request, $restriction_id)
    {
        $restrictions = App::make('coupon-restriction')
            ->newQuery()
            ->where('id', $restriction_id)
            ->delete();

        return response('Restriction deleted', 200);
    }

    /**
     * Search restriction items
     *
     * @param Request $request
     * @param $coupon_id
     * @param $restriction_name
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Illuminate\Http\JsonResponse|\Illuminate\Http\Response
     */
    public function search(Request $request, $coupon_id, $restriction_name)
    {
        if (!config('coupons.restrictions.items.' . $restriction_name) && !config('coupons.restrictions.basket.' . $restriction_name)) {
            return response('Restriction not found', 404);
        }

        $coupon = App::make('coupon')->find($coupon_id);

        if (!$coupon) {
            return response('Coupon not found', 404);
        }

        $coupon_restrictions = $coupon->restrictions()
            ->where('discountable_type', $restriction_name)
            ->pluck('discountable_id');

        $items = App::make(Relation::getMorphedModel($restriction_name))
            ->newQuery()
            ->where(function ($query) use ($request) {
                $query->where('id', (int)$request->input('query'))
                    ->orWhere('name', 'LIKE' , '%' . $request->input('query') . '%');
            })
            ->whereNotIn('id', $coupon_restrictions)
            ->get();

        return response()->json([
            'items' => $items
        ]);
    }

    /**
     * Toogle exclude
     *
     * @param Request $request
     * @param $restriction_id
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Illuminate\Http\Response
     */
    public function toggleExclude(Request $request, $restriction_id)
    {
        $restriction = App::make('coupon-restriction')
            ->newQuery()
            ->where('id', $restriction_id)
            ->first();

        if (!$restriction) {
            return response('Restriction not found', 404);
        }

        $restriction->exclude = !$restriction->exclude;
        $restriction->save();
        $response_text = $restriction->exclude ? 'excluded' : 'included';
        return response('Restriction ' . $response_text, 200);
    }
}
