<?php

namespace Mtc\Coupons\Validators;

use Illuminate\Support\Facades\App;
use Mtc\Basket\Contracts\BasketContract;
use Mtc\Coupons\Coupon;
use Mtc\Modules\Members\Classes\Auth;

/**
 * Class MembersOnly
 * @package Mtc\Coupons\Validators
 */
class MembersOnly
{
    /**
     * @var
     */
    protected $basket;

    /**
     * @var
     */
    protected $member;

    /**
     * @param Coupon $coupon
     * @param $basket
     * @return bool
     */
    public function validate(Coupon $coupon, $basket)
    {
        //Check if first purchase enabled
        if (!$coupon->getBasicRestriction('members_only')) {
            return true;
        }

        //Check if member
        if (Auth::getLoggedInMember()->exists) {
            return true;
        }

        return false;
    }
}
