<?php

namespace Mtc\Coupons\Types;

use Illuminate\Support\Facades\App;
use Mtc\Coupons\Contracts\CouponRepositoryInterface;

/**
 * Class PercentOff
 * @package Mtc\Coupons\Types
 */
class PercentOff extends CouponTypeBase
{
    /**
     * Get Total Discounted Amount
     *
     * @return float
     */
    protected function getDiscountedAmount()
    {
        $discounted_amount = $this->applicable_items
            ->map(function ($item) {
                return $this->applyToItem($item);
            })
            ->sum();

        return round($discounted_amount, 2);
    }

    /**
     * Apply Percentage Discount to Item
     *
     * @param $item
     * @return float|int
     */
    protected function applyToItem($item)
    {
        return round($item->line_total / 100 * $this->coupon->getModel()->value, 2);
    }

    /**
     * Get Discounted Values
     *
     * @param $coupon
     * @param $item
     * @return float
     */
    public function getDiscountedValues($coupon, $item)
    {
        $this->coupon = App::make(CouponRepositoryInterface::class);
        $this->coupon->setModel($coupon);
        return [
            'discounted_percent' => $coupon->value,
        ];
    }
}
