<?php

namespace Mtc\Coupons\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Mtc\Coupons\Rules\ValidCouponCodeValue;
use Mtc\Coupons\Rules\ValidCouponDiscountValue;
use Mtc\Foundation\Rules\OptionalDMYDate;

/**
 * Class CreateCouponRequest
 *
 * @package Mtc\Coupons\Http\Requests
 */
class CreateCouponRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return collect(config('coupons.basic_restrictions'))
            ->map(function ($basic_restriction) {
                return $basic_restriction['request_rule'];
            })
            ->merge([
            'name' => 'required',
            'code' => [
                'required',
                'unique:coupons,code',
                'regex:/^[a-zA-Z0-9]+$/',
                new ValidCouponCodeValue()
            ],
            'redemptions' => 'required|numeric|min:0',
            'value' => [
                'required',
                'numeric',
                'min:0',
                new ValidCouponDiscountValue($this->request->get('type'))
            ],
            'type' => [
                'required',
                Rule::in(array_keys(config('coupons.discount_types', [])))
            ],
            'valid_from' => new OptionalDMYDate(),
            'valid_to' => new OptionalDMYDate(),
            'shipping_modifier' => 'sometimes',
            'sale_restriction' => 'nullable|integer',
            ])
            ->toArray();
    }
}
